<?php

namespace OGPik\Utils;

class Helpers
{        
    /**
     * get_og_image_width
     *
     * Return og:image width
     * 
     * @param  mixed $size
     * @return int
     */
    public static function get_og_image_width($size = 0) {
        return 1200;
    }
    
    /**
     * get_og_image_height
     *
     * Return og:image height
     * 
     * @param  mixed $size
     * @return int
     */
    public static function get_og_image_height($size = 0) {
        return 630;
    }

    /**
     * get_og_image_url
     *
     * Create new og:image url 
     * 
     * @return string
     */
    public static function get_og_image_url()
    {
        if ($url = get_option("ogpik_uuid")) {
            $id = get_queried_object_id();
            if ($id) {
                $url .= rtrim(wp_make_link_relative(get_permalink($id)), "/");
                return trailingslashit(OGPIK_API_URL) . "generate/{$url}/og.png";
            }
        }
        return apply_filters("ogpik_url", null);
    }
}