<?php

namespace OGPik;

use OGPik\Admin;
use OGPik\Extensions;
use OGPik\Utils\Helpers;

class Plugin
{
    /**
     * __construct
     *
     * Class constructor
     *
     * @return void
     */
    public function __construct()
    {
        new Admin\Settings();
        new Admin\Metabox();

        new Extensions\Yoast();
        new Extensions\RankMath();
        new Extensions\AIOSEO();

        add_action("wp_head", [$this, "wp_head"], 20);
    }

        
    /**
     * wp_head
     *
     * Print meta tags
     * 
     * @return void
     */
    public function wp_head()
    {
        // Schema
        $schema = [
            'title' => wp_get_document_title(),
        ];

        // Image
        $image = apply_filters("ogpik_url", null);
        if ($image) {
            $schema["image"] = esc_url($image);
        } else {
            $schema["image"] = esc_url(Helpers::get_og_image_url());
        }

        // Shema print
        printf('<script property="application/ogpik">%s</script>', json_encode($schema));

        // Verification
        if (get_option("ogpik_code")) {
            printf('<meta property="ogpik-verification" content="%s" />', esc_attr(get_option("ogpik_code")));
        }
    }
}