<?php

namespace OGPik\Extensions;

use OGPik\Abstracts\AbstractExtension;
use OGPik\Utils\Helpers;

class AIOSEO extends AbstractExtension
{    
    /**
     * __construct
     *
     * Class constractor
     * 
     * @return void
     */
    public function __construct()
    {
        add_filter("aioseo_facebook_tags", [$this, "facebook_tags"]);
        add_filter("aioseo_twitter_tags", [$this, "twitter_tags"]);
    }
    
    /**
     * facebook_tags
     *
     * Replace og tags for Facebook
     * 
     * @param  array $tags
     * @return array
     */
    public function facebook_tags($tags) {
        add_filter("ogpik_url", function($current) use ($tags) {
            return !$current && isset($tags["og:image"]) ? $tags["og:image"] : null;
        });
        $tags["og:image"] = $this->get_og_image_url();
        $tags["og:image:secure_url"] = $this->get_og_image_url();
        $tags["og:image:width"] = Helpers::get_og_image_width();
        $tags["og:image:height"] = Helpers::get_og_image_height();
        return $tags;
    }

    /**
     * twitter_tags
     *
     * Replace og tags for Twitter
     * 
     * @param  array $tags
     * @return array
     */
    public function twitter_tags($tags) {
        $tags["twitter:image"] = $this->get_og_image_url();
        return $tags;
    }
}