<?php

namespace OGPik\Admin;

use OGPik\Utils\Helpers;

class Settings
{
    /**
     * __construct
     *
     * Class constructor
     *
     * @return void
     */
    public function __construct()
    {
        add_action("admin_menu", function () {
            add_submenu_page("options-general.php", esc_html__("OGPik Settings", "ogpik"), esc_html__("OGPik", "ogpik"), "manage_options", "ogpik", [$this, "setting_page"]);
        });

        register_setting("ogpik_settings_group", "ogpik_uuid", [
            "sanitize_callback" => "sanitize_text_field",
        ]);
    }

    /**
     * setting_page
     *
     * Render settings callback
     *
     * @return void
     */
    public function setting_page()
    {
        if (!current_user_can("manage_options")) {
            return;
        } ?>
        <div class="wrap">
            <h1>
                <?php echo esc_html(get_admin_page_title()); ?>
            </h1>
            <form action="options.php" method="post">
                <?php
                    add_settings_section("ogpik_section_settings", esc_html__("Default settings", "ogpik"), "", "ogpik_settings_general");

                    add_settings_field("ogpik_settings_uuid", __("Website UUID", "ogpik"), [$this, "input_text"], "ogpik_settings_general", "ogpik_section_settings", [
                        "id" => "ogpik_settings_uuid",
                        "name" => "ogpik_uuid",
                    ]);

                    settings_fields("ogpik_settings_group");

                    do_settings_sections("ogpik_settings_general");
                    submit_button();
                ?>
            </form>
        </div>
        <?php
    }

    /**
     * input_text
     *
     * Input text render
     *
     * @param  mixed $val
     * @return void
     */
    function input_text($args)
    {
        printf('<input type="text" id="%s" name="%s" value="%s" class="regular-text" />', esc_attr($args["id"]), esc_attr($args["name"]), esc_attr(get_option($args["name"])));
    }
}
