<?php

namespace OGPik\Admin;

class Metabox
{
    /**
     * __construct
     *
     * Class constructor
     *
     * @return void
     */
    public function __construct()
    {
        add_action("admin_menu", function () {
            add_meta_box("ogpik", "OGPik", [$this, "callback"], ["page", "post"], "normal", "default");
        });
    }

    /**
     * callback
     *
     * Metabox callback
     *
     * @return void
     */
    public function callback()
    {
        $post = get_post();
        $ogpik = get_post_meta($post->ID, "ogpik", true);

        wp_nonce_field(plugin_basename(__FILE__), "ogpik_nonce");
        ?>
        <table class="form-table">
            <tbody>
                <tr>
                    <th><label for="ogpik_title">OGPik title</label></th>
                    <td><input type="text" id="ogpik_title" name="ogpik_title" value="<?php echo esc_attr($ogpik); ?>" class="regular-text"></td>
                </tr>
            </tbody>
        </table>
        <?php
    }
}
