<?php

namespace OGPik\Abstracts;

use OGPik\Utils\Helpers;

abstract class AbstractExtension
{  
    /**
     * opengraph_image
     *
     * Replace og:image 
     * 
     * @param  string $image
     * @return string
     */
    public function opengraph_image($image)
    {
        add_filter("ogpik_url", function() use ($image) {
            return $image;
        });
        return $this->get_og_image_url();
    }

    /**
     * get_og_image_url
     *
     * Create new og:image url 
     * 
     * @return string
     */
    protected function get_og_image_url()
    {
        return Helpers::get_og_image_url();
    }
}
