<?php

/**
 * Plugin Name:       OGPik - OpenGraph images generator
 * Description:       Create eye-catching OpenGraph images for your website automatically. Customize stunning designs, connect via API, and make your brand stand out on every social platform — fast, easy, and effortless.
 * Version:           1.0.0
 * Requires at least: 5.0
 * Requires PHP:      7.4
 * Author:            OGPik team
 * Author URI:        https://ogpik.com
 * Domain Path:       /languages
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-3.0.txt
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

if (!defined("ABSPATH")) {
    exit();
}

if (!class_exists("\OGPik\Plugin")) {
    defined("OGPIK_API_URL") or define("OGPIK_API_URL", "https://api.ogpik.com/");
    define("OGPIK_DIR", plugin_dir_path(__FILE__));

    require_once OGPIK_DIR . "vendor/autoload.php";

    new \OGPik\Plugin();
}
